<?php
namespace VM\FinancialStatementsBundle\Services\Restrictions\DataStructure;


use Import\ApiBundle\Entity\AllegroCategoryItem;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\ApiBundle\Entity\CompanyEmployee;
use VM\ApiBundle\Entity\Department;
use VM\ApiBundle\Entity\DepartmentAllegroCategoryItem;
use VM\ApiBundle\Entity\Employee;

class DepartmentDS
{
    public $segmentSymbol = '';

    public $departmentSymbol = '';

    public $efficiencyType = '';

    public $name = '';

    public $restrictions = array();

    public $restrictionsItems = array();

    //czy brak wymagań skutkuje zmniejszeniem produkcji
    public $isRestrictedForProduction = false;

    /**
     * @var EmployeesDS
     */
    public $Employees;


    public function __construct()
    {
        $this->Employees = new EmployeesDS();
    }

    /**
     * @param Department $Department
     */
    public function setData(Department $Department)
    {
        $this->departmentSymbol = $Department->getType()->getSymbol();
        $this->segmentSymbol = $Department->getMarketSegment()->getSymbol();
        $this->name = $Department->getName();
        $this->setRestrictions($Department->getRestrictions());
        $this->setRestrictionsItems($Department->getItems());
    }

    /**
     * @param $CompanyEmployees
     */
    public function setEmployees($CompanyEmployees)
    {
        /** @var CompanyEmployee $CompanyEmployee */
        foreach($CompanyEmployees as $CompanyEmployee)
        {
            if($CompanyEmployee->getDepartment()->getType()->getSymbol() == $this->departmentSymbol)
            {
                $this->Employees->countAll++;
                if($this->validRestrictions($CompanyEmployee->getEmployee()))
                {
                    $this->Employees->countWithRestrictions++;
                }
            }
        }

        $this->Employees->needSurfaceAll = $this->Employees->countAll * $this->restrictions['surfaceEmployee'];
        $this->Employees->needSurfaceWithRestrictions = $this->Employees->countWithRestrictions * $this->restrictions['surfaceEmployee'];
    }

    /**
     * @param Employee $Employee
     * @return bool
     */
    private function validRestrictions(Employee $Employee)
    {
        $valid = true;

        if(isset($this->restrictions['education']) && !in_array($Employee->getEducation(),$this->restrictions['education']))
        {
            $valid = false;
        }

        if(isset($this->restrictions['studies']) && !in_array($Employee->getStudies(),$this->restrictions['studies']))
        {
            $valid = false;
        }

        if(isset($this->restrictions['driver']) && (strpos($Employee->getDriver(), $this->restrictions['driver']) === false))
        {
            $valid = false;
        }

        return $valid;
    }

    /**
     * @param $restrictions
     */
    private function setRestrictions($restrictions)
    {
        $this->restrictions = json_decode($restrictions,true);
        if(!isset($this->restrictions['surfaceEmployee']))
        {
            $this->restrictions['surfaceEmployee'] = 0;
        }
        if(!isset($this->restrictions['surfaceEquipment']))
        {
            $this->restrictions['surfaceEquipment'] = 0;
        }
        if(!isset($this->restrictions['items']))
        {
            $this->restrictions['items'] = null;
        }
        if(!isset($this->restrictions['driver']))
        {
            $this->restrictions['driver'] = null;
        }
        if(!isset($this->restrictions['efficiencyBiR']))
        {
            $this->restrictions['efficiencyBiR'] = null;
        }

        $this->restrictions['personnel'] = (isset($this->restrictions['personnel'])) ? explode('|',$this->restrictions['personnel']) : array();
        $this->restrictions['education'] = (isset($this->restrictions['education'])) ? explode('|',$this->restrictions['education']) : null;
        $this->restrictions['studies'] = (isset($this->restrictions['studies'])) ? explode('|',$this->restrictions['studies']) : null;
        $this->restrictions['efficiency'] = (isset($this->restrictions['efficiency'])) ? explode('|',$this->restrictions['efficiency']) : array();

        if(isset($this->restrictions['efficiencyType']))
        {
            $this->efficiencyType = $this->restrictions['efficiencyType'];
        }
    }

    /**
     * @param $DepartmentItems
     */
    private function setRestrictionsItems($DepartmentItems)
    {
        /** @var DepartmentAllegroCategoryItem $DepartmentItem */
        foreach($DepartmentItems as $DepartmentItem)
        {
            $this->restrictionsItems[] = new ItemDS($DepartmentItem->getItem(),$DepartmentItem->getQuantity());
        }
    }
}